<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreTestimonianze extends VisualizzatoreComponente {
        private $datiVisualizzazione;
        
        function generaContenutoSezione($dati) {
            $this->datiVisualizzazione = parent::getDb()->leggiSingolaRiga("geec_visualizzatoriTestimonianze",$dati["idElemento"]);
            
            echo"<div class=\"{$this->datiVisualizzazione["spazioOccupato"]}\">
                    <div class=\"testimonials\">";
                        if($this->datiVisualizzazione["tipoVisualizzazione"]=="slider") {
                            echo"<div id=\"testimonials\" class=\"owl-carousel owl-theme\">";                            
                        }
                        else {
                            echo"<div class=\"row\">";
                        }

                        $queryTabellePrezzi = "SELECT * FROM geec_testimonianze WHERE idVisualizzatoreTestimonianze={$dati["idElemento"]} ORDER BY posizione ASC";
                        $risTabelle = parent::getDb()->eseguiQueryLettura($queryTabellePrezzi);
                        while($testimonianza = $risTabelle->fetch_assoc()) {
                            $this->stampaTestimonianza($testimonianza);
                        }
                        echo"</div>
                    </div>
                </div>";
        }
        
        function stampaTestimonianza($testimonianza) {
            if($this->datiVisualizzazione["tipoVisualizzazione"]=="slider" && $this->datiVisualizzazione["elementiPerRiga"]==1) {
                $classeAggiuntiva = "col-lg-6 mx-auto";
            }
            else if($this->datiVisualizzazione["tipoVisualizzazione"]=="tradizionale") {
                $classeAggiuntiva = $this->creaClasseTestimonianza();
            }
            else {
                $classeAggiuntiva = "";
            }
            
            echo"<div class=\"card border-0 $classeAggiuntiva\">";
                    if($this->datiVisualizzazione["mostraImmagini"]=="si") {
                        echo"<div class=\"profile-picture align-content-center\">
                            <img class=\"img-fluid background-image circle mx-auto\" style=\"background-image: url('{$testimonianza["immagine"]}')\">
                        </div>";
                    }
                    echo"<div class=\"text-center mt-5\">
                        <strong>{$testimonianza["autore"]}</strong>
                        <div class=\"blockquote-footer\">{$testimonianza["ruolo"]} <cite> {$testimonianza["azienda"]} </cite></div>";

                        echo"<div class=\"star-rating text-center text-primary my-3\">";
                        if($testimonianza["stelle"]>0) {
                            for($i=1;$i<=$testimonianza["stelle"];$i++) {
                                echo"<i class=\"fa fa-star\"></i>";
                            }
                        }
                    echo"</div>";

                    echo"<hr class=\"mb-0\">
                        <blockquote class=\"blockquote text-center m-0\">
                         <p class=\"lead\">{$testimonianza["testo"]}</p>
                        </blockquote>
                    </div>
                </div>";
        }
        
        function creaClasseTestimonianza() {
            if($this->datiVisualizzazione["elementiPerRiga"]==1) {
                return "col-lg-8 mx-auto";
            }
            else if($this->datiVisualizzazione["elementiPerRiga"]==2) {
                return "col-lg-6";
            }
            else if($this->datiVisualizzazione["elementiPerRiga"]==3) {
                return "col-lg-4";
            }
            else if($this->datiVisualizzazione["elementiPerRiga"]==4) {
                return "col-sm-6 col-lg-3";
            }
            else if($this->datiVisualizzazione["elementiPerRiga"]==6) {
                return "col-sm-6 col-md-4 col-lg-2";
            }
            else {
                return "col-sm-6 col-md-4 col-lg-2";
            }
        }
        
        function getJavascriptAssociato() {
            if($this->datiVisualizzazione["tipoVisualizzazione"]!="slider") {
                return "";
            }
            else {
                return "<script type=\"text/javascript\">
                            $('#testimonials').owlCarousel({
                            loop:false,
                            margin:10,
                            nav:false,
                            responsive:{
                              0:{
                                items:1
                              },
                              600:{
                                items:{$this->datiVisualizzazione["elementiPerRiga"]}
                              },
                              1000:{
                                items:{$this->datiVisualizzazione["elementiPerRiga"]}
                              }
                            }
                          })
                    </script>";
            }
        }
    }